uniform sampler2D tex;

const float gamma = 2.2;

vec3 pow(vec3 color, float power)
{
	color.r = pow(color.r, power);
	color.g = pow(color.g, power);
	color.b = pow(color.b, power);

	return color; 
}

vec4 pow(vec4 color, float power)
{
	color.r = pow(color.r, power);
	color.g = pow(color.g, power);
	color.b = pow(color.b, power);
	color.a = pow(color.a, power);

	return color; 
}


float filmicTonemap(float x)
{
	float mappedX = (x*(6.2*x+0.5))/(x*(6.2*x+1.7)+0.06);

	return mappedX;
}

vec3 filmicTonemap(vec3 x)
{
	vec3 mappedColor = x;
	mappedColor.r = filmicTonemap(mappedColor.r);
	mappedColor.g = filmicTonemap(mappedColor.g);
	mappedColor.b = filmicTonemap(mappedColor.b);

	return mappedColor;
}

void main()
{
	vec4 color = texture2D(tex, gl_TexCoord[0].xy);

	color.rgb += 0.001;	
	
	color.rgb *= 1.0;
	color.r = max(0.0, color.r-0.004);
	color.g = max(0.0, color.g-0.004); 
	color.b = max(0.0, color.b-0.004);

	color.rgb = filmicTonemap(color.rgb);

	gl_FragColor = color;
}
